
/*  A Bison parser, made from /home/gray/gnu/mailutils/mh/pick.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	T_COMP	257
#define	T_DATEFIELD	258
#define	T_STRING	259
#define	T_CFLAGS	260
#define	T_LBRACE	261
#define	T_RBRACE	262
#define	T_BEFORE	263
#define	T_AFTER	264
#define	T_OR	265
#define	T_AND	266
#define	T_NOT	267

#line 1 "pick.y"

/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 2003, 2004 Free Software Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Mailutils is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301 USA */

#include <mh.h>
#include <regex.h>  
#include <pick.h>
  
static node_t *pick_node_create (node_type type, void *a, void *b);
static void set_cflags (char *str);
 
static regex_t *
regex_dup (regex_t *re)
{
  regex_t *rp = xmalloc (sizeof (*rp));
  *rp = *re;
  return rp;
}

static node_t *parse_tree;
static int nesting_level;
static int reg_flags = REG_EXTENDED|REG_ICASE;

#line 45 "pick.y"
typedef union {
  char *string;
  node_t *node;
  regex_t regex;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		29
#define	YYFLAG		-32768
#define	YYNTBASE	14

#define YYTRANSLATE(x) ((unsigned)(x) <= 267 ? pick_yytranslate[x] : 21)

static const char pick_yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13
};

#if YYDEBUG != 0
static const short pick_yyprhs[] = {     0,
     0,     1,     3,     5,     8,     9,    11,    14,    18,    22,
    24,    26,    29,    32,    36,    40,    43,    45
};

static const short pick_yyrhs[] = {    -1,
    15,     0,    18,     0,    15,    18,     0,     0,     6,     0,
    16,     5,     0,    19,    15,    20,     0,    16,     3,    17,
     0,    17,     0,     4,     0,     9,     5,     0,    10,     5,
     0,    18,    12,    18,     0,    18,    11,    18,     0,    13,
    18,     0,     7,     0,     8,     0
};

#endif

#if YYDEBUG != 0
static const short pick_yyrline[] = { 0,
    56,    60,    66,    67,    73,    74,    80,    94,    98,   102,
   106,   110,   121,   132,   136,   140,   146,   152
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const pick_yytname[] = {   "$","error","$undefined.","T_COMP",
"T_DATEFIELD","T_STRING","T_CFLAGS","T_LBRACE","T_RBRACE","T_BEFORE","T_AFTER",
"T_OR","T_AND","T_NOT","input","exprlist","cflags","regex","expr","lbrace","rbrace", NULL
};
#endif

static const short pick_yyr1[] = {     0,
    14,    14,    15,    15,    16,    16,    17,    18,    18,    18,
    18,    18,    18,    18,    18,    18,    19,    20
};

static const short pick_yyr2[] = {     0,
     0,     1,     1,     2,     0,     1,     2,     3,     3,     1,
     1,     2,     2,     3,     3,     2,     1,     1
};

static const short pick_yydefact[] = {     5,
    11,     6,    17,     0,     0,     5,     5,     0,    10,     3,
     5,    12,    13,    16,     4,     5,     7,     5,     5,     5,
     0,     9,    15,    14,    18,     8,     0,     0,     0
};

static const short pick_yydefgoto[] = {    27,
     7,     8,     9,    10,    11,    26
};

static const short pick_yypact[] = {    11,
-32768,-32768,-32768,    -2,     0,    35,    19,    -1,-32768,    -5,
    35,-32768,-32768,-32768,    -5,     2,-32768,    35,    35,    27,
     4,-32768,    10,-32768,-32768,-32768,    16,    30,-32768
};

static const short pick_yypgoto[] = {-32768,
    32,    22,    31,    -6,-32768,-32768
};


#define	YYLAST		48


static const short pick_yytable[] = {    14,
    15,    16,    12,    17,    13,    18,    19,     2,    17,     0,
    -1,    23,    24,    15,     1,    28,     2,     3,    -2,     4,
     5,    19,     1,     6,     2,     3,     0,     4,     5,    29,
     1,     6,     2,     3,    25,     4,     5,    21,     1,     6,
     2,     3,    20,     4,     5,     0,    22,     6
};

static const short pick_yycheck[] = {     6,
     7,     3,     5,     5,     5,    11,    12,     6,     5,    -1,
     0,    18,    19,    20,     4,     0,     6,     7,     0,     9,
    10,    12,     4,    13,     6,     7,    -1,     9,    10,     0,
     4,    13,     6,     7,     8,     9,    10,    16,     4,    13,
     6,     7,    11,     9,    10,    -1,    16,    13
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free
   Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301 USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define pick_yyerrok		(pick_yyerrstatus = 0)
#define pick_yyclearin	(pick_yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto pick_yyacceptlab
#define YYABORT 	goto pick_yyabortlab
#define YYERROR		goto pick_yyerrlab1
/* Like YYERROR except do call pick_yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto pick_yyerrlab
#define YYRECOVERING()  (!!pick_yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (pick_yychar == YYEMPTY && pick_yylen == 1)				\
    { pick_yychar = (token), pick_yylval = (value);			\
      pick_yychar1 = YYTRANSLATE (pick_yychar);				\
      YYPOPSTACK;						\
      goto pick_yybackup;						\
    }								\
  else								\
    { pick_yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		pick_yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		pick_yylex(&pick_yylval, &pick_yylloc, YYLEX_PARAM)
#else
#define YYLEX		pick_yylex(&pick_yylval, &pick_yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		pick_yylex(&pick_yylval, YYLEX_PARAM)
#else
#define YYLEX		pick_yylex(&pick_yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	pick_yychar;			/*  the lookahead symbol		*/
YYSTYPE	pick_yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE pick_yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int pick_yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int pick_yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __pick_yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __pick_yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__pick_yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__pick_yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into pick_yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int pick_yyparse (void *);
#else
int pick_yyparse (void);
#endif
#endif

int
pick_yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int pick_yystate;
  register int pick_yyn;
  register short *pick_yyssp;
  register YYSTYPE *pick_yyvsp;
  int pick_yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int pick_yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	pick_yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE pick_yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *pick_yyss = pick_yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *pick_yyvs = pick_yyvsa;	/*  to allow pick_yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE pick_yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *pick_yyls = pick_yylsa;
  YYLTYPE *pick_yylsp;

#define YYPOPSTACK   (pick_yyvsp--, pick_yyssp--, pick_yylsp--)
#else
#define YYPOPSTACK   (pick_yyvsp--, pick_yyssp--)
#endif

  int pick_yystacksize = YYINITDEPTH;
  int pick_yyfree_stacks = 0;

#ifdef YYPURE
  int pick_yychar;
  YYSTYPE pick_yylval;
  int pick_yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE pick_yylloc;
#endif
#endif

  YYSTYPE pick_yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int pick_yylen;

#if YYDEBUG != 0
  if (pick_yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  pick_yystate = 0;
  pick_yyerrstatus = 0;
  pick_yynerrs = 0;
  pick_yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  pick_yyssp = pick_yyss - 1;
  pick_yyvsp = pick_yyvs;
#ifdef YYLSP_NEEDED
  pick_yylsp = pick_yyls;
#endif

/* Push a new state, which is found in  pick_yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
pick_yynewstate:

  *++pick_yyssp = pick_yystate;

  if (pick_yyssp >= pick_yyss + pick_yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *pick_yyvs1 = pick_yyvs;
      short *pick_yyss1 = pick_yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *pick_yyls1 = pick_yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = pick_yyssp - pick_yyss + 1;

#ifdef pick_yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if pick_yyoverflow is a macro.  */
      pick_yyoverflow("parser stack overflow",
		 &pick_yyss1, size * sizeof (*pick_yyssp),
		 &pick_yyvs1, size * sizeof (*pick_yyvsp),
		 &pick_yyls1, size * sizeof (*pick_yylsp),
		 &pick_yystacksize);
#else
      pick_yyoverflow("parser stack overflow",
		 &pick_yyss1, size * sizeof (*pick_yyssp),
		 &pick_yyvs1, size * sizeof (*pick_yyvsp),
		 &pick_yystacksize);
#endif

      pick_yyss = pick_yyss1; pick_yyvs = pick_yyvs1;
#ifdef YYLSP_NEEDED
      pick_yyls = pick_yyls1;
#endif
#else /* no pick_yyoverflow */
      /* Extend the stack our own way.  */
      if (pick_yystacksize >= YYMAXDEPTH)
	{
	  pick_yyerror("parser stack overflow");
	  if (pick_yyfree_stacks)
	    {
	      free (pick_yyss);
	      free (pick_yyvs);
#ifdef YYLSP_NEEDED
	      free (pick_yyls);
#endif
	    }
	  return 2;
	}
      pick_yystacksize *= 2;
      if (pick_yystacksize > YYMAXDEPTH)
	pick_yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      pick_yyfree_stacks = 1;
#endif
      pick_yyss = (short *) YYSTACK_ALLOC (pick_yystacksize * sizeof (*pick_yyssp));
      __pick_yy_memcpy ((char *)pick_yyss, (char *)pick_yyss1,
		   size * (unsigned int) sizeof (*pick_yyssp));
      pick_yyvs = (YYSTYPE *) YYSTACK_ALLOC (pick_yystacksize * sizeof (*pick_yyvsp));
      __pick_yy_memcpy ((char *)pick_yyvs, (char *)pick_yyvs1,
		   size * (unsigned int) sizeof (*pick_yyvsp));
#ifdef YYLSP_NEEDED
      pick_yyls = (YYLTYPE *) YYSTACK_ALLOC (pick_yystacksize * sizeof (*pick_yylsp));
      __pick_yy_memcpy ((char *)pick_yyls, (char *)pick_yyls1,
		   size * (unsigned int) sizeof (*pick_yylsp));
#endif
#endif /* no pick_yyoverflow */

      pick_yyssp = pick_yyss + size - 1;
      pick_yyvsp = pick_yyvs + size - 1;
#ifdef YYLSP_NEEDED
      pick_yylsp = pick_yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (pick_yydebug)
	fprintf(stderr, "Stack size increased to %d\n", pick_yystacksize);
#endif

      if (pick_yyssp >= pick_yyss + pick_yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (pick_yydebug)
    fprintf(stderr, "Entering state %d\n", pick_yystate);
#endif

  goto pick_yybackup;
 pick_yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* pick_yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  pick_yyn = pick_yypact[pick_yystate];
  if (pick_yyn == YYFLAG)
    goto pick_yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* pick_yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (pick_yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (pick_yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      pick_yychar = YYLEX;
    }

  /* Convert token to internal form (in pick_yychar1) for indexing tables with */

  if (pick_yychar <= 0)		/* This means end of input. */
    {
      pick_yychar1 = 0;
      pick_yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (pick_yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      pick_yychar1 = YYTRANSLATE(pick_yychar);

#if YYDEBUG != 0
      if (pick_yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", pick_yychar, pick_yytname[pick_yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, pick_yychar, pick_yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  pick_yyn += pick_yychar1;
  if (pick_yyn < 0 || pick_yyn > YYLAST || pick_yycheck[pick_yyn] != pick_yychar1)
    goto pick_yydefault;

  pick_yyn = pick_yytable[pick_yyn];

  /* pick_yyn is what to do for this token type in this state.
     Negative => reduce, -pick_yyn is rule number.
     Positive => shift, pick_yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (pick_yyn < 0)
    {
      if (pick_yyn == YYFLAG)
	goto pick_yyerrlab;
      pick_yyn = -pick_yyn;
      goto pick_yyreduce;
    }
  else if (pick_yyn == 0)
    goto pick_yyerrlab;

  if (pick_yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (pick_yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", pick_yychar, pick_yytname[pick_yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (pick_yychar != YYEOF)
    pick_yychar = YYEMPTY;

  *++pick_yyvsp = pick_yylval;
#ifdef YYLSP_NEEDED
  *++pick_yylsp = pick_yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (pick_yyerrstatus) pick_yyerrstatus--;

  pick_yystate = pick_yyn;
  goto pick_yynewstate;

/* Do the default action for the current state.  */
pick_yydefault:

  pick_yyn = pick_yydefact[pick_yystate];
  if (pick_yyn == 0)
    goto pick_yyerrlab;

/* Do a reduction.  pick_yyn is the number of a rule to reduce with.  */
pick_yyreduce:
  pick_yylen = pick_yyr2[pick_yyn];
  if (pick_yylen > 0)
    pick_yyval = pick_yyvsp[1-pick_yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (pick_yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       pick_yyn, pick_yyrline[pick_yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = pick_yyprhs[pick_yyn]; pick_yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", pick_yytname[pick_yyrhs[i]]);
      fprintf (stderr, " -> %s\n", pick_yytname[pick_yyr1[pick_yyn]]);
    }
#endif


  switch (pick_yyn) {

case 1:
#line 57 "pick.y"
{
	     parse_tree = NULL;
	   ;
    break;}
case 2:
#line 61 "pick.y"
{
	     parse_tree = pick_yyvsp[0].node;
	   ;
    break;}
case 4:
#line 68 "pick.y"
{
	     pick_yyval.node = pick_node_create (node_and, pick_yyvsp[-1].node, pick_yyvsp[0].node);
	   ;
    break;}
case 6:
#line 75 "pick.y"
{
	     set_cflags (pick_yyvsp[0].string);
	   ;
    break;}
case 7:
#line 81 "pick.y"
{
	     int rc = regcomp (&pick_yyval.regex, pick_yyvsp[0].string, reg_flags|REG_NOSUB);
	     if (rc)
	       {
		 char errbuf[512];
		 regerror (rc, &pick_yyval.regex, errbuf, sizeof (errbuf));
		 mh_error ("error compiling regex \"%s\": %s",
			   pick_yyvsp[0].string, errbuf);
		 YYERROR;
	       }
	   ;
    break;}
case 8:
#line 95 "pick.y"
{
	     pick_yyval.node = pick_yyvsp[-1].node;
	   ;
    break;}
case 9:
#line 99 "pick.y"
{
	     pick_yyval.node = pick_node_create (node_regex, pick_yyvsp[-1].string, regex_dup (&pick_yyvsp[0].regex));
	   ;
    break;}
case 10:
#line 103 "pick.y"
{
	     pick_yyval.node = pick_node_create (node_regex, NULL, regex_dup (&pick_yyvsp[0].regex));
	   ;
    break;}
case 11:
#line 107 "pick.y"
{
	     pick_yyval.node = pick_node_create (node_datefield, pick_yyvsp[0].string, NULL);
	   ;
    break;}
case 12:
#line 111 "pick.y"
{
	     time_t t;
	     if (mu_parse_date (pick_yyvsp[0].string, &t, NULL))
	       {
		 mh_error (_("bad date format: %s"), pick_yyvsp[0].string);
		 exit (1);
	       }
	     pick_yyval.node = pick_node_create (node_before, NULL, NULL);
	     pick_yyval.node->v.time = t;
	   ;
    break;}
case 13:
#line 122 "pick.y"
{
	     time_t t;
	     if (mu_parse_date (pick_yyvsp[0].string, &t, NULL))
	       {
		 mh_error (_("bad date format: %s"), pick_yyvsp[0].string);
		 exit (1);
	       }
	     pick_yyval.node = pick_node_create (node_after, NULL, NULL);
	     pick_yyval.node->v.time = t;
	   ;
    break;}
case 14:
#line 133 "pick.y"
{
	     pick_yyval.node = pick_node_create (node_and, pick_yyvsp[-2].node, pick_yyvsp[0].node);
	   ;
    break;}
case 15:
#line 137 "pick.y"
{
	     pick_yyval.node = pick_node_create (node_or, pick_yyvsp[-2].node, pick_yyvsp[0].node);
	   ;
    break;}
case 16:
#line 141 "pick.y"
{
	     pick_yyval.node = pick_node_create (node_not, pick_yyvsp[0].node, NULL);
	   ;
    break;}
case 17:
#line 147 "pick.y"
{
	     nesting_level++;
	   ;
    break;}
case 18:
#line 153 "pick.y"
{
	     nesting_level--;
	   ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison.simple"

  pick_yyvsp -= pick_yylen;
  pick_yyssp -= pick_yylen;
#ifdef YYLSP_NEEDED
  pick_yylsp -= pick_yylen;
#endif

#if YYDEBUG != 0
  if (pick_yydebug)
    {
      short *ssp1 = pick_yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != pick_yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++pick_yyvsp = pick_yyval;

#ifdef YYLSP_NEEDED
  pick_yylsp++;
  if (pick_yylen == 0)
    {
      pick_yylsp->first_line = pick_yylloc.first_line;
      pick_yylsp->first_column = pick_yylloc.first_column;
      pick_yylsp->last_line = (pick_yylsp-1)->last_line;
      pick_yylsp->last_column = (pick_yylsp-1)->last_column;
      pick_yylsp->text = 0;
    }
  else
    {
      pick_yylsp->last_line = (pick_yylsp+pick_yylen-1)->last_line;
      pick_yylsp->last_column = (pick_yylsp+pick_yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  pick_yyn = pick_yyr1[pick_yyn];

  pick_yystate = pick_yypgoto[pick_yyn - YYNTBASE] + *pick_yyssp;
  if (pick_yystate >= 0 && pick_yystate <= YYLAST && pick_yycheck[pick_yystate] == *pick_yyssp)
    pick_yystate = pick_yytable[pick_yystate];
  else
    pick_yystate = pick_yydefgoto[pick_yyn - YYNTBASE];

  goto pick_yynewstate;

pick_yyerrlab:   /* here on detecting error */

  if (! pick_yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++pick_yynerrs;

#ifdef YYERROR_VERBOSE
      pick_yyn = pick_yypact[pick_yystate];

      if (pick_yyn > YYFLAG && pick_yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -pick_yyn if nec to avoid negative indexes in pick_yycheck.  */
	  for (x = (pick_yyn < 0 ? -pick_yyn : 0);
	       x < (sizeof(pick_yytname) / sizeof(char *)); x++)
	    if (pick_yycheck[x + pick_yyn] == x)
	      size += strlen(pick_yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (pick_yyn < 0 ? -pick_yyn : 0);
		       x < (sizeof(pick_yytname) / sizeof(char *)); x++)
		    if (pick_yycheck[x + pick_yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, pick_yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      pick_yyerror(msg);
	      free(msg);
	    }
	  else
	    pick_yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	pick_yyerror("parse error");
    }

  goto pick_yyerrlab1;
pick_yyerrlab1:   /* here on error raised explicitly by an action */

  if (pick_yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (pick_yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (pick_yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", pick_yychar, pick_yytname[pick_yychar1]);
#endif

      pick_yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  pick_yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto pick_yyerrhandle;

pick_yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  pick_yyn = pick_yydefact[pick_yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (pick_yyn) goto pick_yydefault;
#endif

pick_yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (pick_yyssp == pick_yyss) YYABORT;
  pick_yyvsp--;
  pick_yystate = *--pick_yyssp;
#ifdef YYLSP_NEEDED
  pick_yylsp--;
#endif

#if YYDEBUG != 0
  if (pick_yydebug)
    {
      short *ssp1 = pick_yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != pick_yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

pick_yyerrhandle:

  pick_yyn = pick_yypact[pick_yystate];
  if (pick_yyn == YYFLAG)
    goto pick_yyerrdefault;

  pick_yyn += YYTERROR;
  if (pick_yyn < 0 || pick_yyn > YYLAST || pick_yycheck[pick_yyn] != YYTERROR)
    goto pick_yyerrdefault;

  pick_yyn = pick_yytable[pick_yyn];
  if (pick_yyn < 0)
    {
      if (pick_yyn == YYFLAG)
	goto pick_yyerrpop;
      pick_yyn = -pick_yyn;
      goto pick_yyreduce;
    }
  else if (pick_yyn == 0)
    goto pick_yyerrpop;

  if (pick_yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (pick_yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++pick_yyvsp = pick_yylval;
#ifdef YYLSP_NEEDED
  *++pick_yylsp = pick_yylloc;
#endif

  pick_yystate = pick_yyn;
  goto pick_yynewstate;

 pick_yyacceptlab:
  /* YYACCEPT comes here.  */
  if (pick_yyfree_stacks)
    {
      free (pick_yyss);
      free (pick_yyvs);
#ifdef YYLSP_NEEDED
      free (pick_yyls);
#endif
    }
  return 0;

 pick_yyabortlab:
  /* YYABORT comes here.  */
  if (pick_yyfree_stacks)
    {
      free (pick_yyss);
      free (pick_yyvs);
#ifdef YYLSP_NEEDED
      free (pick_yyls);
#endif
    }
  return 1;
}
#line 158 "pick.y"


/* Lexical analizer */

struct token
{
  int tok;
  char *val;
};

static iterator_t iterator;

int
pick_yylex ()
{
  struct token *tok;
  
  if (iterator_is_done (iterator))
    return 0;
  iterator_current (iterator, (void **)&tok);
  iterator_next (iterator);
  pick_yylval.string = tok->val;
  return tok->tok;
}

static char *
tokname (int tok)
{
  switch (tok)
    {
    case T_DATEFIELD:
      return "--datefield";
      
    case T_BEFORE:
      return "--before";
      
    case T_AFTER:
      return "--after";
      
    case T_LBRACE:
      return "--lbrace";
      
    case T_RBRACE:
      return "--rbrace";
      
    case T_OR:
      return "--or";
      
    case T_AND:
      return "--and";
      
    case T_NOT:
      return "--not";
    }
  return NULL;
}

int
pick_yyerror (char *s)
{
  int tok = pick_yylex ();
  char *str;
  
  if (!tok)
    str = _("end of input");
  else if (pick_yylval.string)
    str = pick_yylval.string;
  else
    str = tokname (tok);

  if (nesting_level)
    mh_error (_("%s near %s (missing closing brace?)"), s, str);
  else
    mh_error (_("%s near %s"), s, str);
  return 0;
}
  
void
pick_add_token (list_t *list, int tok, char *val)
{
  struct token *tp;
  int rc;
  
  if (!*list && (rc = list_create (list)))
    {
      mh_error(_("cannot create list: %s"), mu_strerror (rc));
      exit (1);
    }
  tp = xmalloc (sizeof (*tp));
  tp->tok = tok;
  tp->val = val;
  list_append (*list, tp);
}

/* Main entry point */
int
pick_parse (list_t toklist)
{
  int rc;
  
  if (!toklist)
    {
      parse_tree = NULL;
      return 0;
    }

  if (list_get_iterator (toklist, &iterator))
    return -1;
  iterator_first (iterator);
  rc = pick_yyparse ();
  iterator_destroy (&iterator);
  return rc;
}


/* Parse tree functions */

node_t *
pick_node_create (node_type type, void *a, void *b)
{
  node_t *node;

  node = xmalloc (sizeof (*node));
  node->type = type;
  node->v.gen.a = a;
  node->v.gen.b = b;
  return node;
}

struct eval_env
{
  message_t msg;
  char *datefield;
};

static int
match_header (message_t msg, char *comp, regex_t *regex)
{
  size_t i, count;
  header_t hdr = NULL;
  char buf[128];
  
  message_get_header (msg, &hdr);
  header_get_field_count (hdr, &count);
  for (i = 1; i <= count; i++)
    {
      header_get_field_name (hdr, i, buf, sizeof buf, NULL);
      if (strcasecmp (buf, comp) == 0)
	{
	  header_get_field_value (hdr, i, buf, sizeof buf, NULL);
	  if (regexec (regex, buf, 0, NULL, 0) == 0)
	    return 1;
	}
    }
  return 0;
}

static int
match_message (message_t msg, regex_t *regex)
{
  stream_t str = NULL;
  char buf[128];
  size_t n;
  
  message_get_stream (msg, &str);
  stream_seek (str, 0, SEEK_SET);
  while (stream_sequential_readline (str, buf, sizeof buf, &n) == 0
	 && n > 0)
    {
      buf[n] = 0;
      if (regexec (regex, buf, 0, NULL, 0) == 0)
	return 1;
    }
  return 0;
}

static int
get_date_field (struct eval_env *env, time_t *t)
{
  header_t hdr;
  char buf[128];
  
  if (message_get_header (env->msg, &hdr))
    return 1;
  if (header_get_value (hdr, env->datefield, buf, sizeof buf, NULL))
    return 1;
  return mu_parse_date (buf, t, NULL);
}

static int
pick_eval_node (node_t *node, struct eval_env *env)
{
  time_t t;
  
  switch (node->type)
    {
    case node_and:
      if (!pick_eval_node (node->v.op.larg, env))
	return 0;
      return pick_eval_node (node->v.op.rarg, env);
	
    case node_or:
      if (pick_eval_node (node->v.op.larg, env))
	return 1;
      return pick_eval_node (node->v.op.rarg, env);

    case node_not:
      return !pick_eval_node (node->v.op.larg, env);
      
    case node_regex:
      if (node->v.re.comp)
	return match_header (env->msg, node->v.re.comp, node->v.re.regex);
      else
	return match_message (env->msg, node->v.re.regex);
      
    case node_datefield:
      env->datefield = node->v.df.datefield;
      return 1;

    case node_before:
      if (get_date_field (env, &t))
	break;
      return t < node->v.time;
      
    case node_after:
      if (get_date_field (env, &t))
	break;
      return t > node->v.time;
    }

  return 0;
}

int
pick_eval (message_t msg)
{
  struct eval_env env;
  
  if (!parse_tree)
    return 1;
  env.msg = msg;
  env.datefield = "date";
  return pick_eval_node (parse_tree, &env);
}

void
set_cflags (char *str)
{
  reg_flags = 0;
  for (; *str; str++)
    {
      switch (*str)
	{
	case 'b':
	case 'B':
	  reg_flags &= ~REG_EXTENDED;
	  break;

	case 'e':
	case 'E':
	  reg_flags |= REG_EXTENDED;
	  break;

	case 'c':
	case 'C':
	  reg_flags &= ~REG_ICASE;
	  break;
	  
	case 'i':
	case 'I':
	  reg_flags |= REG_ICASE;
	  break;

	default:
	  mh_error (_("Invalid regular expression flag: %c"), *str);
	  exit (1);
	}
    }
}
