/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 1999, 2000, 2001, 2005  Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General
   Public License along with this library; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301 USA */

#ifndef _MAILUTILS_URL_H
#define _MAILUTILS_URL_H	1

#include <mailutils/types.h>

#ifdef __cplusplus
extern "C" {
#endif

extern int  mu_url_create    (mu_url_t *, const char *name);
extern void mu_url_destroy   (mu_url_t *);
extern int  mu_url_parse     (mu_url_t);

extern int mu_url_get_scheme  (const mu_url_t, char *, size_t, size_t *);
extern int mu_url_get_user    (const mu_url_t, char *, size_t, size_t *);
extern int mu_url_get_passwd  (const mu_url_t, char *, size_t, size_t *);
extern int mu_url_get_auth    (const mu_url_t, char *, size_t, size_t *);
extern int mu_url_get_host    (const mu_url_t, char *, size_t, size_t *);
extern int mu_url_get_port    (const mu_url_t, long *);
extern int mu_url_get_path    (const mu_url_t, char *, size_t, size_t *);
extern int mu_url_get_query   (const mu_url_t, char *, size_t, size_t *);
extern const char* mu_url_to_string   (const mu_url_t);

extern int mu_url_is_scheme   (mu_url_t, const char* scheme);

extern int mu_url_is_same_scheme (mu_url_t, mu_url_t);
extern int mu_url_is_same_user   (mu_url_t, mu_url_t);
extern int mu_url_is_same_path   (mu_url_t, mu_url_t);
extern int mu_url_is_same_host   (mu_url_t, mu_url_t);
extern int mu_url_is_same_port   (mu_url_t, mu_url_t);

extern char* mu_url_decode    (const char *s);

extern int mu_url_is_ticket   (mu_url_t ticket, mu_url_t url);

#ifdef __cplusplus
}
#endif

#endif /* _MAILUTILS_URL_H */
